<?php

namespace App\Http\Controllers;

use App\Models\KnowledgeBase;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function index()
    {
        $knowledgeBaseItems = KnowledgeBase::orderBy('order')->limit(3)->get();
        return view('home', compact('knowledgeBaseItems'));
    }

    public function contact()
    {
        return view('contact');
    }

    public function dashboard()
    {
        $user = auth()->user();
        $tickets = $user->tickets()->latest()->get();
        return view('dashboard', compact('tickets'));
    }
}

